                  
#include <LPC21xx.H>               // LPC21xx definitions


static void SPI0_Init(void)
{
    PINSEL0 |= 0x5500;             // configure SPI0 pins

    S0SPCCR = 12;                  // SCK = 1 MHz, counter > 8 and even
    S0SPCR  = 0x20;                // Master, no interrupt enable
}


int main (void)
{
    // Fosc = 12.000.000 MHz, PLL not used

    PLLCON  = 0;                   // disable and disconnect PLL 
    PLLFEED = 0xAA;                // PLL Feed Sequence
    PLLFEED = 0x55;                // PLL Feed Sequence

    VPBDIV = 1;                    // Pclk = 12.000.000 MHz

    SPI0_Init();

    while (1)
    {
        S0SPDR  = 0xAA;                // send next SPI channel 0 data
        while (!(S0SPSR & 0x80)) ;     // wait for transfer completed
    }
}
